/* Copyright (C) 2017 RealVNC Ltd.  All Rights Reserved.
 */

/* This is sample code intended to demonstrate part of the
 * VNC Mobile Solution SDK. It is not intended as a production-ready
 * component.
 */

#include <BaseDecoder.h>

#include <vnccommon/StaticUtils.h>
#include <vnccommon/VirtualBase.h>


class ControlMessage : public vnccommon::VirtualBase
{
    VNCCOMMON_DISALLOW_COPYING(ControlMessage)

public:
    ControlMessage();

    virtual void run(BaseDecoderSupport& support) = 0;
};

class ControlMessageStreamCreateCompleted : public ControlMessage
{
public:
    explicit ControlMessageStreamCreateCompleted(StreamID streamId);

    virtual void run(BaseDecoderSupport& support);

private:
    const StreamID mStreamId;
};

class ControlMessageStreamStartCompleted : public ControlMessage
{
public:
    explicit ControlMessageStreamStartCompleted(StreamID streamId);

    virtual void run(BaseDecoderSupport& support);

private:
    const StreamID mStreamId;
};

class ControlMessageStreamStopCompleted : public ControlMessage
{
public:
    explicit ControlMessageStreamStopCompleted(StreamID streamId);

    virtual void run(BaseDecoderSupport& support);

private:
    const StreamID mStreamId;
};

class ControlMessageStreamDestroyCompleted : public ControlMessage
{
public:
    explicit ControlMessageStreamDestroyCompleted(StreamID streamId);

    virtual void run(BaseDecoderSupport& support);

private:
    const StreamID mStreamId;
};

class ControlMessageStreamRecyclePayload : public ControlMessage
{
public:
    ControlMessageStreamRecyclePayload(
            StreamID streamId,
            VNCCommonDecoderStreamPayload *payload);

    virtual void run(BaseDecoderSupport& support);

private:
    const StreamID mStreamId;
    VNCCommonDecoderStreamPayload *const mPayload;
};

